/*	Ian Bailey
	ECE 4220 project 
	imby96@mail.missouri.edu
	05/14/2015
*/
	


#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <wiringPi.h>

//values for IO pins on the pi, commnets next to represenent actual pi pin
const int pumpLED = 0;		//17
const int drainLED = 3;		//22
const int lowSwitch = 1;	//18
const int levelSwitch = 4;	//23
const int highSwitch = 5;	//24

// A 'key' which we can lock and unlock - values are 0 through 3
// This is interpreted internally as a pthread_mutex by wiringPi

// This is a simplified sempaphore implimentation
#define	KEY1	0	//this key is designated for locking the water level variable
#define KEY2	1	//this key is designated for locking the manual mode variable

// This defines the message size to strictly be 40 characters
#define MSG_SIZE	40

// This is the hardcoded port number for the server
#define PORT_NUM	"5000"

// Water Level holding variable
// Also holds the value of the previous water level
// -1 => initialized
// 0 => low water level warning
// 1 => at water level
// 2 => high water level warning
typedef struct WaterLevel{
	int current;
	int prev;
 } waterLevel;
 
//initializing global variable
waterLevel level;
int manual;

//function prototype
void setup (void);

//thread that controls the filling of the tank when the water is below the 
//desired level (Location of the level switch)
PI_THREAD (Low){
	//inf loop
	while(1){
		//checks if the water is below the low level
		if(digitalRead(lowSwitch) && manual == 0){

			//uses a semaphore to protect my level data being exchanged
			piLock(KEY1);
				level.prev = level.current;
				level.current = 0;
			piUnlock(KEY1);
		}
	}
}

//thread that controls the filling of the tank when the water is below the 
//desired level (Location of the level switch)
PI_THREAD (High){
	while(1){
		//checks if the water is above the high level
		if(digitalRead(highSwitch) && manual == 0){

			//uses a semaphore to protect my level data being exchanged
			piLock(KEY1);
				level.prev = level.current;
				level.current = 2;
			piUnlock(KEY1);
		}
	}
}

PI_THREAD (ManageLevel){
	while(1){
		//checks if low alarm was going off, keeps pumpLED on until the
		//desired level is reached
		if(level.current == 0 && manual == 0){
			while(!digitalRead(levelSwitch) && manual == 0){
				digitalWrite(drainLED, LOW);
				digitalWrite(pumpLED, HIGH);
			}
			
			//changing the level holder
			piLock(KEY1);
				level.prev = level.current;
				level.current = 1;
			piUnlock(KEY1);
			
			//shutting off the pump
			digitalWrite(pumpLED, LOW);
		}
		
		//checks if the system starts with water level between the two alarms
		else if(level.current == -1 && !digitalRead(lowSwitch) && !digitalRead(highSwitch) && manual == 0){
			
			//changing the level holder
			piLock(KEY1);
				level.prev = level.current;
				level.current = 1;
			piUnlock(KEY1);
			
			digitalWrite(drainLED, LOW);
			digitalWrite(pumpLED, LOW);
		}
			
		
		//checks if high alarm was going off, keeps drainLED on until the
		//desired level is reached
		else if(level.current == 2 && manual == 0){
			while(digitalRead(levelSwitch) && manual == 0){
				digitalWrite(pumpLED, LOW);
				digitalWrite(drainLED, HIGH);
			}
			
			//changing the level holder
			piLock(KEY1);
				level.prev = level.current;
				level.current = 1;
			piUnlock(KEY1);
			
			//shutting off the drain
			digitalWrite(drainLED, LOW);
		}
	}
}

// get sockaddr, IPv4 or IPv6:
void *get_in_addr(struct sockaddr *sa)
{
    if (sa->sa_family == AF_INET) {
        return &(((struct sockaddr_in*)sa)->sin_addr);
    }
    
    return &(((struct sockaddr_in6*)sa)->sin6_addr);
}

// Thread that exclusively runs the server for this program, it sets up
// the socket, then listens for any requests from clients and handles manual
// modes as well as level indicator
PI_THREAD (Server){
    int sockfd, rv, numbytes;
    struct addrinfo hints, *servinfo, *p;
    struct sockaddr_storage their_addr;
    socklen_t addr_len;
    char s[INET6_ADDRSTRLEN];
    
    char message[MSG_SIZE];
    char buf[MSG_SIZE];
    char buf2[MSG_SIZE];
    
    int i = 0;
    
    memset(&hints, 0, sizeof hints);
    hints.ai_family = AF_UNSPEC; 		// set to AF_INET to force IPv4
    hints.ai_socktype = SOCK_DGRAM;
    hints.ai_flags = AI_PASSIVE; 		// use my IP
    
    //obtaining the information for the servers IP
    if ((rv = getaddrinfo(NULL, PORT_NUM, &hints, &servinfo)) != 0) {
        perror("getaddrinfo: %s\n");
		exit(-1);
    }
    
    // loop through all the results and bind to the first we can
    for(p = servinfo; p != NULL; p = p->ai_next) {
        if ((sockfd = socket(p->ai_family, p->ai_socktype, p->ai_protocol)) == -1) {
            perror("socket");
            continue;
        }
        
        if (bind(sockfd, p->ai_addr, p->ai_addrlen) == -1) {
            close(sockfd);
            perror("bind");
            continue;
        }
        
        break;
    }
    
    //checks for a successful bind
    if (p == NULL) {
        perror("failed to bind socket\n");
        exit(-1);
    }
    
    freeaddrinfo(servinfo);
    
    addr_len = sizeof their_addr;
    
    //loop for the thread to run
    while (1){
		
		//reciving a message from clients
		if ((numbytes = recvfrom(sockfd, buf, MSG_SIZE-1, 0, (struct sockaddr *)&their_addr, &addr_len)) == -1) {
			perror("recvfrom");
			exit(-1);
		}
		
		//prints the message and the IP address of who it is from
		printf("Message: \"%s\" from %s\n", buf, inet_ntop(their_addr.ss_family, get_in_addr((struct sockaddr *)&their_addr), s, sizeof s));
	
		//handles the level case and send the level to the client
		if (strcmp(buf, "LEVEL") == 0){
			
			piLock(KEY1);
				sprintf(message, "%d", level.current);
			piUnlock(KEY1);
			
			if ((numbytes = sendto(sockfd, message, MSG_SIZE-1, 0, (struct sockaddr *)&their_addr, addr_len)) < 0){
				perror("sendto");
				exit(-1);
			}
		}
		
		//handles manual mode on/off
		if (strcmp(buf, "MANUAL") == 0){
			
			if (manual == 0){
				piLock(KEY2);
					manual = 1;
				piUnlock(KEY2);
				
				//shutting off drain and pump
				digitalWrite(drainLED, LOW);
				digitalWrite(pumpLED, LOW);
				
				strcpy(message, "Entered manual mode");
			}
			
			else if (manual == 1){
				
				//shutting off drain and pump
				digitalWrite(drainLED, LOW);
				digitalWrite(pumpLED, LOW);
				
				piLock(KEY2);
					manual = 0;
				piUnlock(KEY2);
				
				strcpy(message, "Exited manual mode");
			}
			
			//sends message to the client
			if ((numbytes = sendto(sockfd, message, MSG_SIZE-1, 0, (struct sockaddr *)&their_addr, addr_len)) < 0){
				perror("sendto");
				exit(-1);
			}
		}
		
		//handles the case to turn on/off the pump in manual mode
		if (strcmp(buf, "PUMP") == 0 && manual == 1){
			
			//prompts the client
			strcpy(message, "ENTER [ON/OFF]");
			
			if ((numbytes = sendto(sockfd, message, MSG_SIZE-1, 0, (struct sockaddr *)&their_addr, addr_len)) < 0){
				perror("sendto");
				exit(-1);
			}
			
			//loops until a valid response (on/off)
			do{
				bzero(buf2, MSG_SIZE);		
				bzero(message, MSG_SIZE);
			
				if ((numbytes = recvfrom(sockfd, buf2, MSG_SIZE-1, 0, (struct sockaddr *)&their_addr, &addr_len)) == -1){
				perror("recvfrom");
				exit(-1);
				}
			
				//turns on the pump
				if(strcmp(buf2, "ON") == 0){
					digitalWrite(pumpLED, HIGH);
					strcpy(message, "Pump turned on");
					
					i = 1;
				}
				
				//turns off the pump
				else if(strcmp(buf2, "OFF") == 0){
					digitalWrite(pumpLED, LOW);
					strcpy(message, "Pump turned off");
					
					i = 1;
				}
			
				//sends success message to the client
				if ((numbytes = sendto(sockfd, message, MSG_SIZE-1, 0, (struct sockaddr *)&their_addr, addr_len)) < 0){
					perror("sendto");
					exit(-1);
				}
			} while( i != 1);
			
			//reseting i
			i = 0;
		}
			
		//handles the case to turn on/off the drain in manual mode
		if (strcmp(buf, "DRAIN") == 0 && manual == 1){
			
			//prompts the client
			strcpy(message, "ENTER [ON/OFF]");
			
			if ((numbytes = sendto(sockfd, message, MSG_SIZE-1, 0, (struct sockaddr *)&their_addr, addr_len)) < 0){
				perror("sendto");
				exit(-1);
			}
			
			//loops until a valid response (on/off)
			do{
				bzero(buf2, MSG_SIZE);		
				bzero(message, MSG_SIZE);
			
				if ((numbytes = recvfrom(sockfd, buf2, MSG_SIZE-1, 0, (struct sockaddr *)&their_addr, &addr_len)) == -1){
				perror("recvfrom");
				exit(-1);
				}
			
				//turns on the drain
				if(strcmp(buf2, "ON") == 0){
					digitalWrite(drainLED, HIGH);
					strcpy(message, "Pump turned on");
					
					i = 1;
				}
				
				//turns off the drain
				else if(strcmp(buf2, "OFF") == 0){
					digitalWrite(drainLED, LOW);
					strcpy(message, "Pump turned off");
					
					i = 1;
				}
			
				//sends success message to the client
				if ((numbytes = sendto(sockfd, message, MSG_SIZE-1, 0, (struct sockaddr *)&their_addr, addr_len)) < 0){
					perror("sendto");
					exit(-1);
				}
			} while( i != 1);
			
			//reseting i
			i = 0;
		}
		
		//exits manual status when connection is closed
		if (strcmp(buf, "REMOTE CONNECTION HAS BEEN CLOSED") == 0 && manual == 1){
			
			//shutting off drain and pump
			digitalWrite(drainLED, LOW);
			digitalWrite(pumpLED, LOW);
			
			piLock(KEY2);
				manual = 0;
			piUnlock(KEY2);
		}
	
		//cleaning the various used buffers
		bzero(message, MSG_SIZE);
		bzero(buf, MSG_SIZE);
		bzero(buf2, MSG_SIZE);
	}
}
		
int main(void){

	setup();
	
	printf("Project is running, press 'ctrl + c' to quit.\n");
	while(1){}
	
	return 0;
}

void setup(void){
	
	//setting up IO pin use
	wiringPiSetup();
	
	//seting up LEDs as outputs
	pinMode(pumpLED, OUTPUT);
	pinMode(drainLED, OUTPUT);
	
	//setting up float switches as inputs
	pinMode(lowSwitch, INPUT);
	pinMode(levelSwitch, INPUT);
	pinMode(highSwitch, INPUT);
	
	//initializes the waterlevel
	piLock(KEY1);
		level.current = -1;
	piUnlock(KEY1);
	
	digitalWrite(pumpLED, LOW);
	digitalWrite(drainLED, LOW);
	
	//starting my threads
	piThreadCreate(Low);
	piThreadCreate(High);
	piThreadCreate(ManageLevel);
	piThreadCreate(Server);
	
	return;
}
